#include "GetPoint.js"
#include "GetObject.js"

function SetPlaneOrigin( plane )
{
	var origin = plane.projectz( moi.view.getCPlane().origin );
	return moi.vectorMath.createFrame( origin, plane.xaxis, plane.yaxis );
}

function DoDimLinear( factoryname )
{
	var pointpicker = moi.ui.createPointPicker();

	var projecttocplane = false;
	try {
		projecttocplane = moi.command.getOption( 'DimProjectToCPlane', true );
		moi.ui.commandUI.ProjectToCPlane.value = projecttocplane;
	} catch(e) {}

	if ( projecttocplane )
		pointpicker.projectToCPlane = true;

    var fromobject = false;
    var factory = moi.command.createFactory( factoryname );

    moi.ui.bindUIToInput( 'AnnotationPreset', 'value', factory.getInput(3) );

    while ( 1 )
    {
        if ( !pointpicker.waitForEvent() )
            return;
			
        if ( pointpicker.event == 'finished' )
            break;

        if ( pointpicker.event == 'FromObject' )
        {
            moi.ui.beginUIUpdate();
            moi.ui.hideUI( 'BasePtPrompt' );
            moi.ui.hideUI( 'FromObject' );
            moi.ui.hideUI( 'ProjectToCPlane' );
            moi.ui.showUI( 'SelectObjectPrompt' );
            moi.ui.endUIUpdate();

            var objectpicker = moi.ui.createObjectPicker();
            objectpicker.allowCurves();
            if ( !GetObject( objectpicker ) )
                return;

            var obj = objectpicker.objects.item(0);
            if ( factory.initFromObject( obj, projecttocplane ) )
            {
                fromobject = true;
                pointpicker.restrictToPlane( SetPlaneOrigin(factory.getInput(0).getValue()), true );
                break;
            }

            moi.ui.beginUIUpdate();
            moi.ui.showUI( 'BasePtPrompt' );
            moi.ui.showUI( 'FromObject' );
            moi.ui.showUI( 'ProjectToCPlane' );
            moi.ui.hideUI( 'SelectObjectPrompt' );
            moi.ui.endUIUpdate();
        }
		else if ( pointpicker.event == 'ProjectToCPlane' )
        {
        	projecttocplane = moi.ui.commandUI.ProjectToCPlane.value;
        	pointpicker.projectToCPlane = projecttocplane;
		}
    }

    pointpicker.projectToCPlane = false;

    if ( !fromobject  )
    {
    	if ( projecttocplane )
    		pointpicker.restrictToPlane( SetPlaneOrigin(pointpicker.ptframe), true );
    	else
    		pointpicker.restrictToPlaneThroughPt( pointpicker.pt, false );

    	factory.setInput( 0, pointpicker.ptframe );

	    moi.ui.beginUIUpdate();
	    moi.ui.hideUI( 'BasePtPrompt' );
	    moi.ui.hideUI( 'SelectObjectPrompt' );
	    moi.ui.hideUI( 'FromObject' );
	    moi.ui.hideUI( 'ProjectToCPlane' );
	    moi.ui.showUI( 'EndPtPrompt' );
	    moi.ui.endUIUpdate();

	    pointpicker.bindResultPt( factory.getInput(1) );

		if ( !projecttocplane )
			pointpicker.bindResultOrientation( factory.getInput(0) );
		
	    if ( !GetPoint( pointpicker ) )
	        return;
    }

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'BasePtPrompt' );
	moi.ui.hideUI( 'SelectObjectPrompt' );
	moi.ui.hideUI( 'EndPtPrompt' );
	moi.ui.hideUI( 'FromObject' );
	moi.ui.hideUI( 'ProjectToCPlane' );
	moi.ui.showUI( 'LocPtPrompt' );
	moi.ui.endUIUpdate();

	if ( !fromobject && !projecttocplane )
	{
		if ( factory.isZDir )
			pointpicker.restrictToPlaneThroughPt( factory.getInput(1).getValue(), true );
		else
			pointpicker.restrictToPlane( SetPlaneOrigin(factory.getInput(0).getValue()), true );
	}

	pointpicker.clearBindings();
	pointpicker.bindResultPt( factory.getInput(2) );
	if ( !GetPoint( pointpicker ) )
		return;

	factory.commit();

	moi.command.setOption( 'DimProjectToCPlane', projecttocplane, true );
}
